/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.profiles;

import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.profiles.ProfilesProvider;
import pro.gravit.launchserver.command.Command;

public class CloneProfileCommand
extends Command {
    private final transient Logger logger = LogManager.getLogger(CloneProfileCommand.class);

    public CloneProfileCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[profile title/uuid] [new profile title]";
    }

    public String getUsageDescription() {
        return "clone profile and profile dir";
    }

    public void invoke(String ... args) throws Exception {
        ProfilesProvider.CompletedProfile profile;
        this.verifyArgs(args, 2);
        try {
            UUID uuid = UUID.fromString(args[0]);
            profile = this.server.config.profilesProvider.get(uuid, null);
        }
        catch (IllegalArgumentException ex) {
            profile = this.server.config.profilesProvider.get(args[0], null);
        }
        this.server.config.profilesProvider.create(args[1], "Description", profile);
        this.logger.info("Profile {} cloned from {}", (Object)args[1], (Object)args[0]);
    }
}

