/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.profiles;

import com.google.gson.JsonElement;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.base.Downloader;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.ClientProfileBuilder;
import pro.gravit.launcher.base.profiles.ClientProfileVersions;
import pro.gravit.launchserver.HttpRequester;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.profiles.ProfilesProvider;
import pro.gravit.launchserver.command.Command;
import pro.gravit.launchserver.helper.AssetsDirHelper;
import pro.gravit.launchserver.helper.MakeProfileHelper;

public class CreateProfileCommand
extends Command {
    private static final Logger logger = LogManager.getLogger();

    public CreateProfileCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[version] [dir] (mirror/generate)";
    }

    public String getUsageDescription() {
        return "Download client";
    }

    public void invoke(String ... args) throws Exception {
        this.verifyArgs(args, 2);
        String versionName = args[0];
        String dirName = args[1];
        Path clientDir = this.server.createTempDirectory("client");
        boolean isMirrorProfileDownload = false;
        if (args.length > 2) {
            isMirrorProfileDownload = args[2].equals("mirror");
        }
        logger.info("Downloading client, it may take some time");
        this.server.mirrorManager.downloadZip(clientDir, "clients/%s.zip", versionName);
        logger.info("Creaing profile file: '{}'", (Object)dirName);
        ClientProfile clientProfile = null;
        try {
            ClientProfile.ServerProfile serverProfile;
            JsonElement clientJson = this.server.mirrorManager.jsonRequest(null, "GET", "clients/%s.json", versionName);
            clientProfile = (ClientProfile)Launcher.gsonManager.configGson.fromJson(clientJson, ClientProfile.class);
            ClientProfileBuilder builder = new ClientProfileBuilder(clientProfile);
            builder.setTitle(dirName);
            builder.setDir(dirName);
            builder.setUuid(UUID.randomUUID());
            clientProfile = builder.createClientProfile();
            if (clientProfile.getServers() != null && (serverProfile = clientProfile.getDefaultServerProfile()) != null) {
                serverProfile.name = dirName;
            }
        }
        catch (Exception e) {
            logger.error("Filed download clientProfile from mirror: '{}' Generation through MakeProfileHelper", (Object)versionName);
            isMirrorProfileDownload = false;
        }
        if (!isMirrorProfileDownload) {
            try {
                MakeProfileHelper.MakeProfileOption[] options;
                ClientProfile.Version version;
                String internalVersion = versionName;
                if (internalVersion.contains("-")) {
                    internalVersion = internalVersion.substring(0, versionName.indexOf(45));
                }
                if ((version = ClientProfile.Version.of((String)internalVersion)).compareTo(ClientProfileVersions.MINECRAFT_1_7_10) <= 0) {
                    logger.warn("Minecraft 1.7.9 and below not supported. Use at your own risk");
                }
                for (MakeProfileHelper.MakeProfileOption option : options = MakeProfileHelper.getMakeProfileOptionsFromDir(clientDir, version)) {
                    logger.debug("Detected option {}", (Object)option.getClass().getSimpleName());
                }
                clientProfile = MakeProfileHelper.makeProfile(version, dirName, options);
            }
            catch (Throwable e) {
                isMirrorProfileDownload = true;
            }
        }
        CreateProfileCommand.pushClientAndDownloadAssets(this.server, clientProfile, clientDir);
        logger.info("Client successfully downloaded: '{}'", (Object)dirName);
    }

    public static ProfilesProvider.CompletedProfile pushClientAndDownloadAssets(LaunchServer server, ClientProfile clientProfile, Path clientDir) throws Exception {
        ProfilesProvider.UncompletedProfile uncompleted = server.config.profilesProvider.create(clientProfile.getTitle(), "Description", null);
        ProfilesProvider.CompletedProfile completed = server.config.profilesProvider.pushUpdate(uncompleted, null, clientProfile, null, List.of(ProfilesProvider.ProfileAction.upload(clientDir, "", true)), List.of(ProfilesProvider.UpdateFlag.USE_DEFAULT_ASSETS));
        String assetIndexPath = String.format("indexes/%s.json", completed.getProfile().getAssetIndex());
        if (!completed.getAssetDir().tryFindRecursive(assetIndexPath).isFound()) {
            Path assetDir = server.createTempDirectory("assets");
            HttpRequester requester = new HttpRequester();
            AssetsDirHelper.AssetInfo assetInfo = AssetsDirHelper.getAssetInfo(requester, completed.getProfile().getAssetIndex());
            List<Downloader.SizedFile> toDownload = AssetsDirHelper.makeToDownloadFiles(assetInfo, completed.getAssetDir());
            logger.info("Download assets {}", (Object)completed.getProfile().getAssetIndex());
            Downloader downloader = CreateProfileCommand.downloadWithProgressBar(completed.getProfile().getAssetIndex(), toDownload, "https://resources.download.minecraft.net/", assetDir);
            downloader.getFuture().get();
            byte[] assetIndexBytes = Launcher.gsonManager.configGson.toJson((JsonElement)assetInfo.assets()).getBytes(StandardCharsets.UTF_8);
            completed = server.config.profilesProvider.pushUpdate(uncompleted, null, clientProfile, List.of(ProfilesProvider.ProfileAction.upload(() -> new ByteArrayInputStream(assetIndexBytes), assetIndexPath), ProfilesProvider.ProfileAction.upload(assetDir, "", true)), List.of(ProfilesProvider.ProfileAction.upload(clientDir, "", true)), List.of(ProfilesProvider.UpdateFlag.USE_DEFAULT_ASSETS));
        } else {
            completed = server.config.profilesProvider.pushUpdate(uncompleted, null, clientProfile, null, List.of(ProfilesProvider.ProfileAction.upload(clientDir, "", true)), List.of(ProfilesProvider.UpdateFlag.USE_DEFAULT_ASSETS));
        }
        return completed;
    }
}

