/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.server.authlib;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import pro.gravit.launcher.server.authlib.InstallAuthlib;
import pro.gravit.launcher.server.authlib.LibrariesHashFileModifier;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class PatchPropertiesModifier
implements LibrariesHashFileModifier {
    @Override
    public byte[] apply(byte[] data, InstallAuthlib.InstallAuthlibContext context) throws IOException {
        CharSequence[] lines = new String(data).split("\n");
        String version = null;
        int linePatchedHashIndex = -1;
        int lineOriginalHashIndex = -1;
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].startsWith("version=")) {
                version = lines[i].split("=")[1];
                continue;
            }
            if (lines[i].startsWith("patchedHash=")) {
                linePatchedHashIndex = i;
                continue;
            }
            if (!lines[i].startsWith("originalHash=")) continue;
            lineOriginalHashIndex = i;
        }
        if (version == null) {
            LogHelper.warning("Unable to parse version from patch.properties");
            return data;
        }
        if (linePatchedHashIndex < 0) {
            LogHelper.warning("Unable to parse patchedHash from patch.properties");
            return data;
        }
        if (lineOriginalHashIndex < 0) {
            LogHelper.warning("Unable to parse originalHash from patch.properties");
            return data;
        }
        Path patchedFile = context.workdir.resolve("cache").resolve("patched_".concat(version).concat(".jar"));
        Path originalFile = context.workdir.resolve("cache").resolve("mojang_".concat(version).concat(".jar"));
        if (Files.notExists(patchedFile, new LinkOption[0])) {
            LogHelper.warning("Unable to find %s. Maybe you should start the server at least once?", patchedFile);
            return data;
        }
        if (Files.notExists(originalFile, new LinkOption[0])) {
            LogHelper.warning("Unable to find %s. Maybe you should start the server at least once?", originalFile);
            return data;
        }
        String newPatchedHash = SecurityHelper.toHex(SecurityHelper.digest(SecurityHelper.DigestAlgorithm.SHA256, patchedFile)).toUpperCase();
        String newOriginalHash = SecurityHelper.toHex(SecurityHelper.digest(SecurityHelper.DigestAlgorithm.SHA256, originalFile)).toUpperCase();
        lines[linePatchedHashIndex] = "patchedHash=".concat(newPatchedHash);
        lines[lineOriginalHashIndex] = "originalHash=".concat(newOriginalHash);
        return String.join((CharSequence)"\n", lines).getBytes(StandardCharsets.UTF_8);
    }
}

