/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.core.api.features;

import java.security.PublicKey;
import java.util.concurrent.CompletableFuture;
import pro.gravit.launcher.core.api.features.FeatureAPI;

public interface HardwareVerificationFeatureAPI
extends FeatureAPI {
    public CompletableFuture<SecurityLevelInfo> getSecurityInfo();

    public CompletableFuture<SecurityLevelVerification> privateKeyVerification(PublicKey var1, byte[] var2);

    public CompletableFuture<Void> sendHardwareInfo(HardwareStatisticData var1, HardwareIdentifyData var2);

    public static enum Os {
        WINDOWS("windows"),
        LINUX("linux"),
        MACOS("macos");

        public final String name;

        private Os(String name) {
            this.name = name;
        }
    }

    public static enum Arch {
        X86("x86"),
        X86_64("x86-64"),
        ARM64("arm64"),
        ARM32("arm32");

        public final String name;

        private Arch(String name) {
            this.name = name;
        }
    }

    public record HardwareIdentifyData(String baseboardSerialNumber, String persistentStorageId, byte[] edid) {
    }

    public record HardwareStatisticData(Arch arch, Os os, long totalPhysicalMemory, int logicalProcessors, int physicalProcessors, long processorMaxFreq, boolean battery, String graphicCard) {
    }

    public static interface SecurityLevelVerification {
        public HardwareCollectLevel getHardwareCollectLevel();

        public static enum HardwareCollectLevel {
            NONE,
            ONLY_STATISTIC,
            ALL;

        }
    }

    public static interface SecurityLevelInfo {
        public boolean isRequired();

        public byte[] getSignData();
    }
}

