/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.server.setup;

import java.io.BufferedWriter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.jar.JarFile;
import pro.gravit.launcher.base.events.request.GetPublicKeyRequestEvent;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.ClientProfileVersions;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.RequestService;
import pro.gravit.launcher.base.request.auth.GetPublicKeyRequest;
import pro.gravit.launcher.base.request.websockets.StdWebSocketService;
import pro.gravit.launcher.server.ServerWrapper;
import pro.gravit.launcher.server.setup.ServerWrapperCommands;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class ServerWrapperSetup {
    public ServerWrapperCommands commands = new ServerWrapperCommands();
    public URLClassLoader urlClassLoader;

    public void run() throws Exception {
        String agentClassName;
        String mainClassName;
        ServerWrapper wrapper = ServerWrapper.wrapper;
        String jarName = System.getenv("SERVERWRAPPER_JAR_NAME");
        if (jarName == null) {
            System.out.println("Print server jar filename:");
            jarName = this.commands.commandHandler.readLine();
        }
        Path jarPath = Paths.get(jarName, new String[0]);
        try (JarFile file = new JarFile(jarPath.toFile());){
            URL jarURL = jarPath.toUri().toURL();
            this.urlClassLoader = new URLClassLoader(new URL[]{jarURL});
            LogHelper.info((String)"Check server jar MainClass");
            mainClassName = file.getManifest().getMainAttributes().getValue("Main-Class");
            agentClassName = file.getManifest().getMainAttributes().getValue("Premain-Class");
            if (mainClassName == null) {
                LogHelper.error((String)"Main-Class not found in MANIFEST");
                return;
            }
            try {
                Class.forName(mainClassName, false, this.urlClassLoader);
            }
            catch (ClassNotFoundException e) {
                LogHelper.error((Throwable)e);
                file.close();
                return;
            }
        }
        LogHelper.info((String)"Found MainClass %s", (Object[])new Object[]{mainClassName});
        if (agentClassName != null) {
            LogHelper.info((String)"Found PremainClass %s", (Object[])new Object[]{agentClassName});
        }
        if (wrapper.config.serverName == null || wrapper.config.serverName.isEmpty()) {
            System.out.println("Print your server name:");
            wrapper.config.serverName = this.commands.commandHandler.readLine();
        }
        wrapper.config.mainclass = mainClassName;
        boolean altMode = false;
        for (int i = 0; i < 10; ++i) {
            if (!Request.isAvailable() || Request.getRequestService().isClosed()) {
                StdWebSocketService service;
                if (wrapper.config.address == null || wrapper.config.address.isEmpty()) {
                    System.out.println("Print launchserver websocket host( ws://host:port/api ):");
                    wrapper.config.address = this.commands.commandHandler.readLine();
                }
                try {
                    service = (StdWebSocketService)StdWebSocketService.initWebSockets((String)wrapper.config.address).get();
                }
                catch (Throwable e) {
                    LogHelper.error((Throwable)e);
                    continue;
                }
                Request.setRequestService((RequestService)service);
            }
            if (wrapper.config.extendedTokens == null || wrapper.config.extendedTokens.get("checkServer") == null) {
                System.out.println("Print server token:");
                String checkServerToken = this.commands.commandHandler.readLine();
                wrapper.config.extendedTokens.put("checkServer", new Request.ExtendedToken(checkServerToken, 0L));
            }
            wrapper.updateLauncherConfig();
            try {
                wrapper.restore();
                wrapper.getProfiles();
                GetPublicKeyRequestEvent publicKeyRequestEvent = (GetPublicKeyRequestEvent)new GetPublicKeyRequest().request();
                wrapper.config.encodedServerRsaPublicKey = publicKeyRequestEvent.rsaPublicKey;
                wrapper.config.encodedServerEcPublicKey = publicKeyRequestEvent.ecdsaPublicKey;
                break;
            }
            catch (Throwable e) {
                LogHelper.error((Throwable)e);
                if (!Request.isAvailable() || !(Request.getRequestService() instanceof AutoCloseable)) continue;
                ((AutoCloseable)Request.getRequestService()).close();
            }
        }
        if (wrapper.profile != null && wrapper.profile.getVersion().compareTo(ClientProfileVersions.MINECRAFT_1_18) >= 0) {
            LogHelper.info((String)"Switch to alternative start mode (1.18)");
            if (!wrapper.config.classpath.contains(jarName)) {
                wrapper.config.classpath.add(jarName);
            }
            wrapper.config.classLoaderConfig = ClientProfile.ClassLoaderConfig.LAUNCHER;
            altMode = true;
        }
        wrapper.saveConfig();
        LogHelper.info((String)"Generate start script");
        Path startScript = JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE ? Paths.get("start.bat", new String[0]) : Paths.get("start.sh", new String[0]);
        if (Files.exists(startScript, new LinkOption[0])) {
            LogHelper.warning((String)"start script found. Move to start.bak");
            Path startScriptBak = Paths.get("start.bak", new String[0]);
            IOHelper.move((Path)startScript, (Path)startScriptBak);
        }
        try (BufferedWriter writer = IOHelper.newWriter((Path)startScript);){
            if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX) {
                writer.append("#!/bin/bash\n\n");
            }
            writer.append("\"");
            writer.append(IOHelper.resolveJavaBin((Path)Paths.get(System.getProperty("java.home"), new String[0]), (boolean)true).toAbsolutePath().toString());
            writer.append("\" ");
            if (mainClassName.contains("bungee")) {
                LogHelper.info((String)"Found BungeeCord mainclass. Modules dir change to modules_srv");
                writer.append(JVMHelper.jvmProperty((String)"serverwrapper.modulesDir", (String)"modules_srv"));
                writer.append(" ");
            }
            if (agentClassName != null) {
                writer.append("-javaagent:ServerWrapper.jar ");
                writer.append("-Dserverwrapper.agentproxy=".concat(agentClassName));
                writer.append(" ");
            }
            writer.append("-cp ");
            String pathServerWrapper = IOHelper.getCodeSource(ServerWrapper.class).getFileName().toString();
            writer.append(pathServerWrapper);
            if (!altMode) {
                if (JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE) {
                    writer.append(";");
                } else {
                    writer.append(":");
                }
                writer.append(jarName);
            }
            writer.append(" ");
            writer.append(ServerWrapper.class.getName());
            writer.append("\n");
        }
        if (JVMHelper.OS_TYPE != JVMHelper.OS.MUSTDIE && !startScript.toFile().setExecutable(true)) {
            LogHelper.error((String)"Failed to set executable %s", (Object[])new Object[]{startScript});
        }
    }
}

