/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.server.authlib;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import pro.gravit.launcher.server.authlib.InstallAuthlib;
import pro.gravit.launcher.server.authlib.LibrariesHashFileModifier;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class DownloadContextModifier
implements LibrariesHashFileModifier {
    @Override
    public byte[] apply(byte[] data, InstallAuthlib.InstallAuthlibContext context) throws IOException {
        CharSequence[] lines = new String(data).split("\n");
        for (int i = 0; i < lines.length; ++i) {
            if (!lines[i].contains("mojang_")) continue;
            CharSequence[] separated = ((String)lines[i]).split("\t");
            Path path = context.workdir.resolve("cache").resolve(separated[2]);
            if (Files.notExists(path, new LinkOption[0])) {
                LogHelper.warning((String)"Unable to find %s. Maybe you should start the server at least once?", (Object[])new Object[]{path});
                return data;
            }
            separated[0] = SecurityHelper.toHex((byte[])SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.SHA256, (Path)path));
            lines[i] = String.join((CharSequence)"\t", separated);
        }
        return String.join((CharSequence)"\n", lines).getBytes(StandardCharsets.UTF_8);
    }
}

