/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import pro.gravit.launcher.core.LauncherNetworkAPI;
import pro.gravit.launcher.core.api.model.UserPermissions;

public class ClientPermissions
implements UserPermissions {
    public static final ClientPermissions DEFAULT = new ClientPermissions();
    @LauncherNetworkAPI
    private List<String> roles;
    @LauncherNetworkAPI
    private List<String> perms;
    private transient List<PermissionPattern> available;

    public ClientPermissions() {
    }

    public ClientPermissions(List<String> roles, List<String> permissions) {
        this.roles = new ArrayList<String>(roles);
        this.perms = new ArrayList<String>(permissions);
    }

    public static ClientPermissions getSuperuserAccount() {
        ClientPermissions perm = new ClientPermissions();
        perm.addPerm("*");
        return perm;
    }

    @Override
    public boolean hasRole(String role) {
        return this.roles != null && this.roles.contains(role);
    }

    public synchronized void compile() {
        if (this.available != null) {
            return;
        }
        if (this.perms == null) {
            this.perms = new ArrayList<String>(0);
        }
        this.available = new ArrayList<PermissionPattern>(this.perms.size());
        for (String a : this.perms) {
            this.available.add(new PermissionPattern(a));
        }
    }

    @Override
    public boolean hasPerm(String action) {
        if (this.available == null) {
            this.compile();
        }
        for (PermissionPattern p : this.available) {
            if (!p.match(action)) continue;
            return true;
        }
        return false;
    }

    public void addRole(String role) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>(1);
        }
        this.roles.add(role);
    }

    public void addPerm(String perm) {
        if (this.perms == null) {
            this.perms = new ArrayList<String>(1);
        }
        this.perms.add(perm);
        if (this.available == null) {
            this.available = new ArrayList<PermissionPattern>(1);
        }
        this.available.add(new PermissionPattern(perm));
    }

    public void removePerm(String action) {
        if (this.perms == null) {
            return;
        }
        if (this.available == null) {
            return;
        }
        this.perms.remove(action);
        this.available.remove(new PermissionPattern(action));
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public List<String> getPerms() {
        return this.perms;
    }

    public String toString() {
        return "ClientPermissions{roles=" + String.join((CharSequence)", ", this.roles == null ? Collections.emptyList() : this.roles) + ", actions=" + String.join((CharSequence)", ", this.perms == null ? Collections.emptyList() : this.perms) + "}";
    }

    public static class PermissionPattern {
        private final String[] parts;
        private final int priority;

        public PermissionPattern(String pattern) {
            int pos;
            ArrayList<String> prepare = new ArrayList<String>();
            int i = 0;
            while ((pos = pattern.indexOf("*", i)) >= 0) {
                prepare.add(pattern.substring(i, pos));
                i = pos + 1;
            }
            prepare.add(pattern.substring(i));
            this.priority = prepare.size() - 1;
            this.parts = prepare.toArray(new String[0]);
        }

        public int getPriority() {
            return this.priority;
        }

        public boolean match(String str) {
            if (this.parts.length == 0) {
                return true;
            }
            if (this.parts.length == 1) {
                return this.parts[0].equals(str);
            }
            int offset = 0;
            if (!str.startsWith(this.parts[0])) {
                return false;
            }
            if (!str.endsWith(this.parts[this.parts.length - 1])) {
                return false;
            }
            for (int i = 1; i < this.parts.length - 1; ++i) {
                int pos = str.indexOf(this.parts[i], offset);
                if (pos < 0) {
                    return false;
                }
                offset = pos + 1;
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PermissionPattern that = (PermissionPattern)o;
            return this.priority == that.priority && Arrays.equals(this.parts, that.parts);
        }

        public int hashCode() {
            int result = Objects.hash(this.priority);
            result = 31 * result + Arrays.hashCode(this.parts);
            return result;
        }
    }
}

