/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.request.websockets;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.SSLException;
import pro.gravit.launcher.base.events.RequestEvent;
import pro.gravit.launcher.base.events.request.ErrorRequestEvent;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.RequestException;
import pro.gravit.launcher.base.request.RequestService;
import pro.gravit.launcher.base.request.WebSocketEvent;
import pro.gravit.launcher.base.request.websockets.ClientWebSocketService;
import pro.gravit.launcher.base.request.websockets.WebSocketRequest;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class StdWebSocketService
extends ClientWebSocketService
implements RequestService {
    private final ConcurrentHashMap<UUID, CompletableFuture> futureMap = new ConcurrentHashMap();
    private final HashSet<RequestService.EventHandler> eventHandlers = new HashSet();
    private final HashSet<ClientWebSocketService.EventHandler> legacyEventHandlers = new HashSet();

    public StdWebSocketService(String address) throws SSLException {
        super(address);
    }

    public static CompletableFuture<StdWebSocketService> initWebSockets(String address) {
        StdWebSocketService service;
        try {
            service = new StdWebSocketService(address);
        }
        catch (SSLException e) {
            throw new SecurityException(e);
        }
        service.registerResults();
        service.registerRequests();
        CompletableFuture<StdWebSocketService> future = new CompletableFuture<StdWebSocketService>();
        service.openAsync(() -> {
            future.complete(service);
            JVMHelper.RUNTIME.addShutdownHook(new Thread(() -> service.close()));
        }, future::completeExceptionally);
        return future;
    }

    @Deprecated
    public void registerEventHandler(ClientWebSocketService.EventHandler handler) {
        this.legacyEventHandlers.add(handler);
    }

    @Deprecated
    public void unregisterEventHandler(ClientWebSocketService.EventHandler handler) {
        this.legacyEventHandlers.remove(handler);
    }

    public <T extends WebSocketEvent> void processEventHandlers(T event) {
        for (RequestService.EventHandler eventHandler : this.eventHandlers) {
            if (!eventHandler.eventHandle(event)) continue;
            return;
        }
        for (ClientWebSocketService.EventHandler eventHandler : this.legacyEventHandlers) {
            if (!eventHandler.eventHandle(event)) continue;
            return;
        }
    }

    @Override
    public <T extends WebSocketEvent> void eventHandle(T webSocketEvent) {
        if (webSocketEvent instanceof RequestEvent) {
            RequestEvent event = (RequestEvent)webSocketEvent;
            if (event.requestUUID == null) {
                LogHelper.warning("Request event type %s.requestUUID is null", event.getType() == null ? "null" : event.getType());
                return;
            }
            if (event.requestUUID.equals(RequestEvent.eventUUID)) {
                this.processEventHandlers(webSocketEvent);
                return;
            }
            CompletableFuture future = this.futureMap.get(event.requestUUID);
            if (future != null) {
                if (event instanceof ErrorRequestEvent) {
                    future.completeExceptionally(new RequestException(((ErrorRequestEvent)event).error));
                } else {
                    future.complete(event);
                }
                this.futureMap.remove(event.requestUUID);
            } else {
                this.processEventHandlers(event);
                return;
            }
        }
        this.processEventHandlers(webSocketEvent);
    }

    @Override
    public <T extends WebSocketEvent> CompletableFuture<T> request(Request<T> request) {
        CompletableFuture result = new CompletableFuture();
        this.futureMap.put(request.requestUUID, result);
        try {
            this.sendObject(request, (Type)((Object)WebSocketRequest.class));
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(e);
        }
        return result;
    }

    @Override
    public void registerEventHandler(RequestService.EventHandler handler) {
        this.eventHandlers.add(handler);
    }

    @Override
    public void unregisterEventHandler(RequestService.EventHandler handler) {
        this.eventHandlers.remove(handler);
    }

    @Override
    public <T extends WebSocketEvent> T requestSync(Request<T> request) {
        try {
            return (T)((WebSocketEvent)this.request(request).get());
        }
        catch (InterruptedException e) {
            throw new RequestException("Request interrupted");
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw new RequestException(cause);
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }
}

