/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.TrustManagerFactory;
import pro.gravit.launcher.core.LauncherInject;
import pro.gravit.utils.helper.LogHelper;

public final class CertificatePinningTrustManager {
    @LauncherInject(value="launchercore.certificates")
    private static List<byte[]> secureConfigCertificates;
    private static X509Certificate[] certs;
    private static volatile TrustManagerFactory INSTANCE;

    private static X509Certificate[] getInternalCertificates() {
        CertificateFactory certFactory = null;
        try {
            certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            return new X509Certificate[0];
        }
        CertificateFactory finalCertFactory = certFactory;
        return (X509Certificate[])secureConfigCertificates.stream().map(cert -> {
            X509Certificate x509Certificate;
            ByteArrayInputStream input = new ByteArrayInputStream((byte[])cert);
            try {
                x509Certificate = (X509Certificate)finalCertFactory.generateCertificate(input);
            }
            catch (Throwable t$) {
                try {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (Throwable x2) {
                        t$.addSuppressed(x2);
                    }
                    throw t$;
                }
                catch (IOException | CertificateException e) {
                    LogHelper.error(e);
                    return null;
                }
            }
            ((InputStream)input).close();
            return x509Certificate;
        }).toArray(X509Certificate[]::new);
    }

    public static X509Certificate[] getCertificates() {
        if (certs == null) {
            certs = CertificatePinningTrustManager.getInternalCertificates();
        }
        return Arrays.copyOf(certs, certs.length);
    }

    public static TrustManagerFactory getTrustManager() throws KeyStoreException, NoSuchAlgorithmException, IOException, CertificateException {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        if (certs == null) {
            certs = CertificatePinningTrustManager.getInternalCertificates();
        }
        TrustManagerFactory factory = TrustManagerFactory.getInstance("X.509");
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(null, null);
        int i = 1;
        for (X509Certificate cert : certs) {
            String alias = Integer.toString(i);
            keystore.setCertificateEntry(alias, cert);
            ++i;
        }
        factory.init(keystore);
        INSTANCE = factory;
        return factory;
    }

    static {
        certs = null;
    }
}

