/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.server;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Type;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.LauncherConfig;
import pro.gravit.launcher.base.api.AuthService;
import pro.gravit.launcher.base.api.ClientService;
import pro.gravit.launcher.base.api.ConfigService;
import pro.gravit.launcher.base.api.KeyService;
import pro.gravit.launcher.base.config.JsonConfigurable;
import pro.gravit.launcher.base.events.request.AuthRequestEvent;
import pro.gravit.launcher.base.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.base.profiles.optional.triggers.OptionalTrigger;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.RequestCoreFeatureAPIImpl;
import pro.gravit.launcher.base.request.RequestFeatureAPIImpl;
import pro.gravit.launcher.base.request.auth.AuthRequest;
import pro.gravit.launcher.base.request.auth.GetAvailabilityAuthRequest;
import pro.gravit.launcher.base.request.update.ProfilesRequest;
import pro.gravit.launcher.base.request.websockets.StdWebSocketService;
import pro.gravit.launcher.core.api.LauncherAPI;
import pro.gravit.launcher.core.api.LauncherAPIHolder;
import pro.gravit.launcher.core.api.features.AuthFeatureAPI;
import pro.gravit.launcher.core.api.features.HardwareVerificationFeatureAPI;
import pro.gravit.launcher.core.api.features.ProfileFeatureAPI;
import pro.gravit.launcher.core.api.features.TextureUploadFeatureAPI;
import pro.gravit.launcher.core.api.features.UserFeatureAPI;
import pro.gravit.launcher.server.ServerAgent;
import pro.gravit.launcher.server.ServerWrapperBridge;
import pro.gravit.launcher.server.ServerWrapperGsonManager;
import pro.gravit.launcher.server.authlib.InstallAuthlib;
import pro.gravit.launcher.server.setup.ServerWrapperSetup;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.launch.BasicLaunch;
import pro.gravit.utils.launch.ClassLoaderControl;
import pro.gravit.utils.launch.Launch;
import pro.gravit.utils.launch.LaunchOptions;
import pro.gravit.utils.launch.LegacyLaunch;
import pro.gravit.utils.launch.ModuleLaunch;

public class ServerWrapper
extends JsonConfigurable<Config> {
    public static final Path configFile = Paths.get(System.getProperty("serverwrapper.configFile", "ServerWrapperConfig.json"), new String[0]);
    public static final boolean disableSetup = Boolean.parseBoolean(System.getProperty("serverwrapper.disableSetup", "false"));
    public static ServerWrapper wrapper;
    public static ClassLoaderControl classLoaderControl;
    public Config config;
    public ClientProfile profile;
    public ClientProfile.ServerProfile serverProfile;

    public ServerWrapper(Type type, Path configPath) {
        super(type, configPath);
    }

    public static void initGson() {
        Launcher.gsonManager = new ServerWrapperGsonManager();
        Launcher.gsonManager.initGson();
    }

    public static void main(String ... args) throws Throwable {
        LogHelper.printVersion("ServerWrapper");
        LogHelper.printLicense("ServerWrapper");
        wrapper = new ServerWrapper((Type)((Object)Config.class), configFile);
        wrapper.run(args);
    }

    public void restore() throws Exception {
        if (this.config.oauth != null) {
            Request.setOAuth(this.config.authId, this.config.oauth, this.config.oauthExpireTime);
        }
        if (this.config.extendedTokens != null) {
            Request.addAllExtendedToken(this.config.extendedTokens);
        }
        Request.RequestRestoreReport report = Request.restore(this.config.oauth != null, false, false);
        if (report.userInfo != null) {
            if (report.userInfo.playerProfile != null) {
                AuthService.username = report.userInfo.playerProfile.username;
                AuthService.uuid = report.userInfo.playerProfile.uuid;
            }
            AuthService.permissions = report.userInfo.permissions;
        }
    }

    public void getProfiles() throws Exception {
        ProfilesRequestEvent result = (ProfilesRequestEvent)new ProfilesRequest().request();
        for (ClientProfile p : result.profiles) {
            LogHelper.debug("Get profile: %s", p.getTitle());
            boolean isFound = false;
            for (ClientProfile.ServerProfile srv : p.getServers()) {
                if (srv == null || !srv.name.equals(this.config.serverName)) continue;
                this.serverProfile = srv;
                this.profile = p;
                Launcher.profile = p;
                AuthService.profile = p;
                LogHelper.debug("Found profile: %s", Launcher.profile.getTitle());
                isFound = true;
                break;
            }
            if (!isFound) continue;
            break;
        }
        if (this.profile == null) {
            LogHelper.warning("Not connected to ServerProfile. May be serverName incorrect?");
        }
    }

    public void initialize() throws Exception {
        ServerWrapper.initGson();
        AuthRequest.registerProviders();
        GetAvailabilityAuthRequest.registerProviders();
        OptionalAction.registerProviders();
        OptionalTrigger.registerProviders();
        LogHelper.debug("Read ServerWrapperConfig.json");
        this.loadConfig();
    }

    public void connect() throws Exception {
        this.config.applyEnv();
        this.updateLauncherConfig();
        StdWebSocketService service = StdWebSocketService.initWebSockets(this.config.address).get();
        service.reconnectCallback = () -> {
            LogHelper.debug("WebSocket connect closed. Try reconnect");
            try {
                Request.reconnect();
                this.getProfiles();
            }
            catch (Exception e) {
                LogHelper.error(e);
            }
        };
        Request.setRequestService(service);
        LauncherAPIHolder.setCoreAPI(new RequestCoreFeatureAPIImpl(Request.getRequestService()));
        LauncherAPIHolder.setCreateApiFactory(authId -> {
            RequestFeatureAPIImpl impl = new RequestFeatureAPIImpl(Request.getRequestService(), (String)authId);
            return new LauncherAPI(Map.of(AuthFeatureAPI.class, impl, UserFeatureAPI.class, impl, ProfileFeatureAPI.class, impl, TextureUploadFeatureAPI.class, impl, HardwareVerificationFeatureAPI.class, impl));
        });
        if (this.config.authId != null) {
            LauncherAPIHolder.changeAuthId(this.config.authId);
        } else {
            RequestFeatureAPIImpl impl = new RequestFeatureAPIImpl(Request.getRequestService(), null);
            LauncherAPIHolder.setApi(new LauncherAPI(Map.of(AuthFeatureAPI.class, impl, UserFeatureAPI.class, impl, ProfileFeatureAPI.class, impl, TextureUploadFeatureAPI.class, impl, HardwareVerificationFeatureAPI.class, impl)));
        }
        if (this.config.logFile != null) {
            LogHelper.addOutput(IOHelper.newWriter(Paths.get(this.config.logFile, new String[0]), true));
        }
        this.restore();
        this.getProfiles();
        if (this.config.encodedServerRsaPublicKey != null) {
            KeyService.serverRsaPublicKey = SecurityHelper.toPublicRSAKey(this.config.encodedServerRsaPublicKey);
        }
        if (this.config.encodedServerEcPublicKey != null) {
            KeyService.serverEcPublicKey = SecurityHelper.toPublicECDSAKey(this.config.encodedServerEcPublicKey);
        }
        ClientService.nativePath = this.config.nativesDir;
        ConfigService.serverName = this.config.serverName;
        if (this.config.configServiceSettings != null) {
            this.config.configServiceSettings.apply();
        }
    }

    public void runCompatClasses() throws Throwable {
        if (this.config.compatClasses != null) {
            for (String e : this.config.compatClasses) {
                Class<?> clazz = classLoaderControl == null ? Class.forName(e) : classLoaderControl.getClass(e);
                MethodHandle runMethod = MethodHandles.lookup().findStatic(clazz, "run", MethodType.methodType(Void.TYPE, ClassLoaderControl.class));
                runMethod.invoke(classLoaderControl);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void run(String ... args) throws Throwable {
        Launch launch;
        String classname;
        this.initialize();
        if (args.length > 0 && args[0].equalsIgnoreCase("setup") && !disableSetup) {
            ServerWrapperSetup setup = new ServerWrapperSetup();
            setup.run();
            System.exit(0);
        }
        if (args.length > 2 && args[0].equalsIgnoreCase("bridge") && !disableSetup) {
            ServerWrapperBridge bridge = new ServerWrapperBridge();
            this.connect();
            bridge.run(args[1], args[2]);
            System.exit(0);
        }
        if (args.length > 1 && args[0].equalsIgnoreCase("installAuthlib") && !disableSetup) {
            InstallAuthlib command = new InstallAuthlib();
            command.run(args[1]);
            System.exit(0);
        }
        this.connect();
        if (this.config.properties != null) {
            for (Map.Entry entry : this.config.properties.entrySet()) {
                System.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.config.encodedServerRsaPublicKey != null) {
            KeyService.serverRsaPublicKey = SecurityHelper.toPublicRSAKey(this.config.encodedServerRsaPublicKey);
        }
        if (this.config.encodedServerEcPublicKey != null) {
            KeyService.serverEcPublicKey = SecurityHelper.toPublicECDSAKey(this.config.encodedServerEcPublicKey);
        }
        String string = classname = this.config.mainclass == null || this.config.mainclass.isEmpty() ? args[0] : this.config.mainclass;
        if (classname.isEmpty()) {
            LogHelper.error("MainClass not found. Please set MainClass for ServerWrapper.json or first commandline argument");
            System.exit(-1);
        }
        if (this.config.oauth == null && (this.config.extendedTokens == null || this.config.extendedTokens.isEmpty())) {
            LogHelper.error("Auth not configured. Please use 'java -jar ServerWrapper.jar setup'");
            System.exit(-1);
        }
        if (this.config.autoloadLibraries) {
            if (!ServerAgent.isAgentStarted()) {
                throw new UnsupportedOperationException("JavaAgent not found, autoloadLibraries not available");
            }
            if (this.config.librariesDir == null) {
                throw new UnsupportedOperationException("librariesDir is null, autoloadLibraries not available");
            }
            Path path = Paths.get(this.config.librariesDir, new String[0]);
            LogHelper.info("Load libraries");
            ServerAgent.loadLibraries(path);
        }
        LogHelper.info("ServerWrapper: LaunchServer address: %s. Title: %s", this.config.address, Launcher.profile != null ? Launcher.profile.getTitle() : "unknown");
        LogHelper.info("Minecraft Version (for profile): %s", ServerWrapper.wrapper.profile == null ? "unknown" : ServerWrapper.wrapper.profile.getVersion().toString());
        if (this.config.args != null && !this.config.args.isEmpty()) {
            String[] stringArray = this.config.args.toArray(new String[0]);
        } else if (args.length > 0) {
            String[] stringArray = new String[args.length - 1];
            System.arraycopy(args, 1, stringArray, 0, args.length - 1);
        } else {
            String[] stringArray = args;
        }
        if (this.config.loadNatives != null) {
            for (String e : this.config.loadNatives) {
                System.load(Paths.get(this.config.nativesDir, new String[0]).resolve(ClientService.findLibrary(e)).toAbsolutePath().toString());
            }
        }
        switch (this.config.classLoaderConfig) {
            case LAUNCHER: {
                launch = new LegacyLaunch();
                System.setProperty("java.class.path", String.join((CharSequence)File.pathSeparator, this.config.classpath));
                break;
            }
            case MODULE: {
                launch = new ModuleLaunch();
                System.setProperty("java.class.path", String.join((CharSequence)File.pathSeparator, this.config.classpath));
                break;
            }
            default: {
                launch = ServerAgent.isAgentStarted() ? new BasicLaunch(ServerAgent.inst) : new BasicLaunch();
            }
        }
        LaunchOptions options = new LaunchOptions();
        options.enableHacks = this.config.enableHacks;
        options.moduleConf = this.config.moduleConf;
        classLoaderControl = launch.init(this.config.classpath.stream().map(x$0 -> Paths.get(x$0, new String[0])).flatMap(p -> {
            if (!Files.isDirectory(p, new LinkOption[0])) {
                return Stream.of(p);
            }
            try {
                return Files.walk(p, new FileVisitOption[0]).filter(e -> e.getFileName().toString().endsWith(".jar"));
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }).collect(Collectors.toCollection(ArrayList::new)), this.config.nativesDir, options);
        if (ServerAgent.isAgentStarted()) {
            ClientService.instrumentation = ServerAgent.inst;
        }
        ClientService.classLoaderControl = classLoaderControl;
        ClientService.baseURLs = classLoaderControl.getURLs();
        LogHelper.info("Start Minecraft Server");
        try {
            void var3_9;
            this.runCompatClasses();
            LogHelper.debug("Invoke main method %s with %s", classname, launch.getClass().getName());
            launch.launch(this.config.mainclass, this.config.mainmodule, Arrays.asList(var3_9));
        }
        catch (Throwable e) {
            LogHelper.error(e);
            System.exit(-1);
        }
    }

    public void updateLauncherConfig() {
        LauncherConfig cfg = new LauncherConfig(this.config.address, null, null, new HashMap<String, byte[]>(), "ServerWrapper");
        Launcher.setConfig(cfg);
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(Config config) {
        this.config = config;
    }

    @Override
    public Config getDefaultConfig() {
        Config newConfig = new Config();
        newConfig.serverName = "";
        newConfig.mainclass = "";
        newConfig.extendedTokens = new HashMap<String, Request.ExtendedToken>();
        newConfig.args = new ArrayList<String>();
        newConfig.classpath = new ArrayList<String>();
        newConfig.address = "";
        newConfig.classLoaderConfig = ClientProfile.ClassLoaderConfig.SYSTEM_ARGS;
        newConfig.env = LauncherConfig.LauncherEnvironment.STD;
        newConfig.properties = new HashMap<String, String>();
        return newConfig;
    }

    public static final class Config {
        @Deprecated
        public String projectname;
        public String address;
        public String serverName;
        public boolean autoloadLibraries;
        public String logFile;
        public List<String> classpath;
        public ClientProfile.ClassLoaderConfig classLoaderConfig;
        public String librariesDir;
        public String mainclass;
        public String mainmodule;
        public String nativesDir = "natives";
        public List<String> args;
        public List<String> compatClasses;
        public List<String> loadNatives;
        public String authId;
        public AuthRequestEvent.OAuthRequestEvent oauth;
        public long oauthExpireTime;
        public Map<String, Request.ExtendedToken> extendedTokens;
        public LauncherConfig.LauncherEnvironment env;
        public LaunchOptions.ModuleConf moduleConf = new LaunchOptions.ModuleConf();
        public byte[] encodedServerRsaPublicKey;
        public byte[] encodedServerEcPublicKey;
        public boolean enableHacks;
        public Map<String, String> properties;
        public ConfigServiceSettings configServiceSettings = new ConfigServiceSettings();

        public void applyEnv() {
            this.authId = Config.applyEnvOrDefault("SERVERWRAPPER_AUTH_ID", this.authId);
            this.address = Config.applyEnvOrDefault("SERVERWRAPPER_ADDRESS", this.address);
            this.serverName = Config.applyEnvOrDefault("SERVERWRAPPER_SERVER_NAME", this.serverName);
            this.encodedServerEcPublicKey = Config.applyEnvOrDefault("SERVERWRAPPER_EC_PUBLIC_KEY", Base64.getUrlDecoder()::decode, null);
            this.encodedServerRsaPublicKey = Config.applyEnvOrDefault("SERVERWRAPPER_RSA_PUBLIC_KEY", Base64.getUrlDecoder()::decode, null);
            String token = System.getenv("SERVERWRAPPER_CHECK_SERVER_TOKEN");
            if (token != null) {
                if (this.extendedTokens == null) {
                    this.extendedTokens = new HashMap<String, Request.ExtendedToken>();
                }
                this.extendedTokens.put("checkServer", new Request.ExtendedToken(token, 0L));
            }
        }

        private static String applyEnvOrDefault(String envName, String def) {
            String value = System.getenv(envName);
            if (value == null) {
                return def;
            }
            return value;
        }

        private static <T> T applyEnvOrDefault(String envName, Function<String, T> mappingFunction, T def) {
            String value = System.getenv(envName);
            if (value == null) {
                return def;
            }
            return mappingFunction.apply(value);
        }

        public static class ConfigServiceSettings {
            public boolean disableLogging = false;
            public boolean checkServerNeedProperties = false;
            public boolean checkServerNeedHardware = false;

            public void apply() {
                ConfigService.disableLogging = this.disableLogging;
                ConfigService.checkServerConfig.needHardware = this.checkServerNeedHardware;
                ConfigService.checkServerConfig.needProperties = this.checkServerNeedProperties;
            }
        }
    }
}

