/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.server.authlib;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import pro.gravit.launcher.server.authlib.DownloadContextModifier;
import pro.gravit.launcher.server.authlib.LibrariesHashFileModifier;
import pro.gravit.launcher.server.authlib.LibrariesLstModifier;
import pro.gravit.launcher.server.authlib.PatchPropertiesModifier;
import pro.gravit.launcher.server.authlib.PatchesLstModifier;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class InstallAuthlib {
    private static final Map<String, LibrariesHashFileModifier> modifierMap = new HashMap<String, LibrariesHashFileModifier>();
    private static final String tempLaunchAuthLibName = "authlib.jar";

    public void run(String ... args) throws Exception {
        ZipEntry e;
        ZipOutputStream output;
        ZipInputStream input;
        boolean deleteAuthlibAfterInstall = false;
        final InstallAuthlibContext context = new InstallAuthlibContext();
        if (args[0].startsWith("http://") || args[0].startsWith("https://")) {
            Path tempAuthlib = Paths.get(tempLaunchAuthLibName, new String[0]);
            LogHelper.info("Download %s to %s", args[0], tempAuthlib);
            try (InputStream input2 = IOHelper.newInput(new URL(args[0]));){
                IOHelper.transfer(input2, tempAuthlib);
            }
            context.pathToAuthlib = tempAuthlib.toAbsolutePath();
            deleteAuthlibAfterInstall = true;
        } else {
            context.pathToAuthlib = Paths.get(args[0], new String[0]).toAbsolutePath();
        }
        if (Files.notExists(context.pathToAuthlib, new LinkOption[0])) {
            throw new FileNotFoundException(context.pathToAuthlib.toString());
        }
        LogHelper.info("Search .jar files in %s", context.workdir.toAbsolutePath());
        IOHelper.walk(context.workdir, (FileVisitor<Path>)new SimpleFileVisitor<Path>(this){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (file.getFileName().toString().endsWith(".jar") && !file.equals(context.pathToAuthlib)) {
                    context.files.add(file);
                }
                return FileVisitResult.CONTINUE;
            }
        }, true);
        context.files.sort(Comparator.comparingInt(path -> -path.getNameCount()));
        LogHelper.info("Search authlib in %d files", context.files.size());
        for (Path path2 : context.files) {
            boolean foundAuthlib = false;
            input = IOHelper.newZipInput(path2);
            try {
                ZipEntry e2 = input.getNextEntry();
                while (e2 != null) {
                    String name = e2.getName();
                    if (!e2.isDirectory() && name.contains("com/mojang/authlib") && !foundAuthlib) {
                        boolean isJarFile = name.endsWith(".jar");
                        String prefix = isJarFile ? name : name.substring(0, name.indexOf("com/mojang/authlib"));
                        context.repack.add(new RepackInfo(path2, prefix, isJarFile));
                        foundAuthlib = true;
                    }
                    if (!e2.isDirectory() && modifierMap.containsKey(name)) {
                        context.hashes.add(new HashFile(path2, name, modifierMap.get(name)));
                    }
                    e2 = input.getNextEntry();
                }
            }
            finally {
                if (input == null) continue;
                input.close();
            }
        }
        Path tmpFile = Paths.get("repack.tmp", new String[0]);
        for (RepackInfo ri : context.repack) {
            LogHelper.info("Found authlib in %s (prefix '%s' jar %s)", ri.path, ri.prefix, ri.isJarFile ? "true" : "false");
            input = IOHelper.newZipInput(ri.path);
            try {
                output = new ZipOutputStream(IOHelper.newOutput(tmpFile));
                try {
                    e = input.getNextEntry();
                    while (e != null && (e.getName().equals("META-INF") || e.getName().equals("META-INF/") || e.getName().equals("META-INF/MANIFEST.MF"))) {
                        ZipEntry newEntry = IOHelper.newZipEntry(e);
                        output.putNextEntry(newEntry);
                        IOHelper.transfer((InputStream)input, (OutputStream)output);
                        e = input.getNextEntry();
                    }
                    if (!ri.isJarFile) {
                        try (ZipInputStream input2 = new ZipInputStream(IOHelper.newInput(context.pathToAuthlib));){
                            ZipEntry e2 = input2.getNextEntry();
                            while (e2 != null) {
                                if (e2.getName().startsWith("META-INF")) {
                                    e2 = input2.getNextEntry();
                                    continue;
                                }
                                String newName = !ri.prefix.endsWith("/") && !e2.getName().startsWith("/") && !ri.prefix.isEmpty() ? ri.prefix.concat("/").concat(e2.getName()) : ri.prefix.concat(e2.getName());
                                ZipEntry newEntry = IOHelper.newZipEntry(newName);
                                output.putNextEntry(newEntry);
                                IOHelper.transfer((InputStream)input2, (OutputStream)output);
                                e2 = input2.getNextEntry();
                            }
                        }
                    }
                    while (e != null) {
                        ZipEntry newEntry;
                        if (e.getName().startsWith(ri.prefix)) {
                            if (ri.isJarFile) {
                                if (context.repackedAuthlibBytes == null) {
                                    byte[] orig = IOHelper.read(input);
                                    context.repackedAuthlibBytes = this.repackAuthlibJar(orig, context.pathToAuthlib);
                                }
                                newEntry = IOHelper.newZipEntry(e);
                                output.putNextEntry(newEntry);
                                output.write(context.repackedAuthlibBytes);
                                e = input.getNextEntry();
                                continue;
                            }
                            if (context.repackedAuthlibFiles == null) {
                                context.repackedAuthlibFiles = this.getNames(context.pathToAuthlib);
                            }
                            if (context.repackedAuthlibFiles.contains(e.getName().substring(ri.prefix.length()))) {
                                e = input.getNextEntry();
                                continue;
                            }
                        }
                        newEntry = IOHelper.newZipEntry(e);
                        output.putNextEntry(newEntry);
                        IOHelper.transfer((InputStream)input, (OutputStream)output);
                        e = input.getNextEntry();
                    }
                }
                finally {
                    output.close();
                }
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
            Files.delete(ri.path);
            Files.move(tmpFile, ri.path, new CopyOption[0]);
        }
        LogHelper.info("%d authlib files repacked", context.repack.size());
        for (HashFile hf : context.hashes) {
            LogHelper.info("Found hash file %s in %s", hf.prefix, hf.path);
            input = IOHelper.newZipInput(hf.path);
            try {
                output = new ZipOutputStream(IOHelper.newOutput(tmpFile));
                try {
                    e = input.getNextEntry();
                    while (e != null) {
                        ZipEntry newEntry = IOHelper.newZipEntry(e);
                        output.putNextEntry(newEntry);
                        if (e.getName().equals(hf.prefix)) {
                            byte[] orig = IOHelper.read(input);
                            byte[] bytes = hf.modifier.apply(orig, context);
                            output.write(bytes);
                        } else {
                            IOHelper.transfer((InputStream)input, (OutputStream)output);
                        }
                        e = input.getNextEntry();
                    }
                }
                finally {
                    output.close();
                }
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
            Files.delete(hf.path);
            Files.move(tmpFile, hf.path, new CopyOption[0]);
        }
        LogHelper.info("%d hash files repacked", context.hashes.size());
        if (deleteAuthlibAfterInstall) {
            LogHelper.info("Delete %s", context.pathToAuthlib);
            Files.delete(context.pathToAuthlib);
        }
        LogHelper.info("Completed");
    }

    private Set<String> getNames(Path path) throws IOException {
        HashSet<String> set = new HashSet<String>();
        try (ZipInputStream input = IOHelper.newZipInput(path);){
            ZipEntry e = input.getNextEntry();
            while (e != null) {
                if (!e.getName().startsWith("META-INF")) {
                    set.add(e.getName());
                }
                e = input.getNextEntry();
            }
        }
        return set;
    }

    private byte[] repackAuthlibJar(byte[] data, Path path) throws IOException {
        try (ZipInputStream input = new ZipInputStream(new ByteArrayInputStream(data));){
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            try (ZipOutputStream output = new ZipOutputStream(result);){
                HashSet<String> blacklist = new HashSet<String>();
                try (ZipInputStream input2 = IOHelper.newZipInput(path);){
                    ZipEntry e = input2.getNextEntry();
                    while (e != null) {
                        if (e.getName().startsWith("META-INF")) {
                            e = input2.getNextEntry();
                            continue;
                        }
                        ZipEntry newEntry = IOHelper.newZipEntry(e);
                        output.putNextEntry(newEntry);
                        IOHelper.transfer((InputStream)input2, (OutputStream)output);
                        blacklist.add(e.getName());
                        e = input2.getNextEntry();
                    }
                }
                ZipEntry e = input.getNextEntry();
                while (e != null) {
                    if (blacklist.contains(e.getName())) {
                        e = input.getNextEntry();
                        continue;
                    }
                    ZipEntry newEntry = IOHelper.newZipEntry(e);
                    output.putNextEntry(newEntry);
                    IOHelper.transfer((InputStream)input, (OutputStream)output);
                    e = input.getNextEntry();
                }
            }
            byte[] byArray = result.toByteArray();
            return byArray;
        }
    }

    static {
        modifierMap.put("META-INF/libraries.list", new LibrariesLstModifier());
        modifierMap.put("patch.properties", new PatchPropertiesModifier());
        modifierMap.put("META-INF/download-context", new DownloadContextModifier());
        modifierMap.put("META-INF/patches.list", new PatchesLstModifier());
    }

    public static class InstallAuthlibContext {
        public Path pathToAuthlib;
        public Path workdir = IOHelper.WORKING_DIR;
        public List<Path> files = new ArrayList<Path>();
        public List<RepackInfo> repack = new ArrayList<RepackInfo>();
        public List<HashFile> hashes = new ArrayList<HashFile>();
        public byte[] repackedAuthlibBytes = null;
        public Set<String> repackedAuthlibFiles = null;
        public LocalDateTime timestamp = LocalDateTime.now();
    }

    public static class RepackInfo {
        public Path path;
        public String prefix;
        public boolean isJarFile;

        public RepackInfo(Path path, String prefix, boolean isJarFile) {
            this.path = path;
            this.prefix = prefix;
            this.isJarFile = isJarFile;
        }
    }

    public static class HashFile {
        public Path path;
        public String prefix;
        public LibrariesHashFileModifier modifier;

        public HashFile(Path path, String prefix, LibrariesHashFileModifier modifier) {
            this.path = path;
            this.prefix = prefix;
            this.modifier = modifier;
        }
    }
}

