/*
 * Decompiled with CFR 0.152.
 */
package com.gravitlauncher.socketbridge.client;

import com.gravitlauncher.socketbridge.ErrorResponse;
import com.gravitlauncher.socketbridge.MessageHeader;
import com.gravitlauncher.socketbridge.Registry;
import com.gravitlauncher.socketbridge.client.AbstractClient;
import com.gravitlauncher.socketbridge.utils.IOUtils;
import com.gravitlauncher.socketbridge.utils.ThreadUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SocketClient
extends AbstractClient
implements AutoCloseable {
    private final ExecutorService sendExecutor;
    private final Thread readThread;
    private final Socket socket;

    public SocketClient(Registry registryRequest, Registry registryResponse, Socket socket) {
        super(registryRequest, registryResponse);
        this.sendExecutor = Executors.newSingleThreadExecutor(ThreadUtils.DAEMON_THREAD_FACTORY);
        this.readThread = ThreadUtils.DAEMON_THREAD_FACTORY.newThread(this::runReadThread);
        this.socket = socket;
    }

    public SocketClient(Registry registryRequest, Registry registryResponse, SocketAddress address) throws IOException {
        super(registryRequest, registryResponse);
        this.socket = new Socket();
        this.socket.connect(address);
        this.sendExecutor = Executors.newSingleThreadExecutor(ThreadUtils.DAEMON_THREAD_FACTORY);
        this.readThread = ThreadUtils.DAEMON_THREAD_FACTORY.newThread(this::runReadThread);
    }

    @Override
    public CompletableFuture<MessageHeader> send(Object object, boolean isResponse, long requestId) {
        String name = this.registryRequest.get(object.getClass());
        if (name == null) {
            throw new RuntimeException(String.format("Object %s not registered", object.getClass().getName()));
        }
        CompletableFuture<MessageHeader> future = new CompletableFuture<MessageHeader>();
        this.sendExecutor.submit(() -> {
            byte[] serialized = this.gson.toJson(object).getBytes(StandardCharsets.UTF_8);
            MessageHeader header = new MessageHeader(name, isResponse, requestId, serialized.length);
            try {
                this.socket.getOutputStream().write(header.serialize());
                this.socket.getOutputStream().write(serialized);
                future.complete(header);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<?> sendRequest(Object object) {
        CompletableFuture future = new CompletableFuture();
        this.send(object, false, this.counter.getAndIncrement()).handle((ok, err) -> {
            if (err == null) {
                this.futureMap.put(ok.requestId(), future);
            } else {
                future.completeExceptionally((Throwable)err);
            }
            return null;
        });
        return future;
    }

    private void runReadThread() {
        try {
            InputStream input = this.socket.getInputStream();
            byte[] header = new byte[27];
            byte[] content = new byte[8192];
            while (!Thread.interrupted()) {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                IOUtils.readNBytes(input, header, 0, 27);
                int required = (int)MessageHeader.calculateSize(ByteBuffer.wrap(header));
                output.write(header);
                if (content.length < required) {
                    content = new byte[required];
                }
                IOUtils.readNBytes(input, content, 0, required);
                output.write(content, 0, required);
                byte[] packet = output.toByteArray();
                ByteBuffer byteBuffer = ByteBuffer.wrap(packet);
                MessageHeader header1 = MessageHeader.deserialize(byteBuffer);
                byteBuffer.get(content, 0, (int)header1.contentLength());
                Object obj = null;
                Class clazz = this.registryResponse.get(header1.name());
                if (clazz != null) {
                    try (InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(content, 0, (int)header1.contentLength()));){
                        obj = this.gson.fromJson((Reader)reader, clazz);
                    }
                }
                this.onMessage(header1, obj);
            }
        }
        catch (Throwable e) {
            for (CompletableFuture f : this.futureMap.values()) {
                f.completeExceptionally(e);
            }
        }
    }

    @Override
    protected void onMessage(MessageHeader header, Object obj) {
        if (!header.isResponse()) {
            this.onEvent(header, obj);
            return;
        }
        CompletableFuture future = (CompletableFuture)this.futureMap.get(header.requestId());
        if (obj == null) {
            if (future != null) {
                future.completeExceptionally(new RuntimeException(String.format("Name '%s' not registered", header.name())));
            } else {
                this.onEvent(header, null);
            }
            return;
        }
        if (future != null) {
            if (obj instanceof ErrorResponse) {
                ErrorResponse errorResponse = (ErrorResponse)obj;
                future.completeExceptionally(new RuntimeException(errorResponse.error));
            } else {
                future.complete(obj);
            }
        } else {
            this.onEvent(header, obj);
        }
    }

    @Override
    protected void onEvent(MessageHeader header, Object obj) {
    }

    @Override
    public void close() {
        if (this.readThread != null && this.readThread.isAlive()) {
            this.readThread.interrupt();
        }
        if (this.sendExecutor != null && !this.sendExecutor.isShutdown()) {
            this.sendExecutor.shutdownNow();
        }
    }
}

