/*
 * Decompiled with CFR 0.152.
 */
package com.gravitlauncher.socketbridge.server;

import com.gravitlauncher.socketbridge.MessageHeader;
import com.gravitlauncher.socketbridge.Registry;
import com.gravitlauncher.socketbridge.client.SocketClient;
import com.gravitlauncher.socketbridge.server.AbstractServer;
import com.gravitlauncher.socketbridge.utils.ThreadUtils;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class SocketServer
extends AbstractServer
implements AutoCloseable {
    private final ServerSocket socket;
    private final Thread acceptThread;
    private final Set<SocketClient> clients = ConcurrentHashMap.newKeySet();
    private final Map<String, AbstractServer.ServerHandler> handlers = new ConcurrentHashMap<String, AbstractServer.ServerHandler>();

    public SocketServer(Registry registryRequest, Registry registryResponse, ServerSocket socket) {
        super(registryRequest, registryResponse);
        this.socket = socket;
        this.acceptThread = ThreadUtils.DAEMON_THREAD_FACTORY.newThread(this::runAcceptThread);
        this.acceptThread.start();
    }

    public SocketServer(Registry registryRequest, Registry registryResponse, SocketAddress address) throws IOException {
        super(registryRequest, registryResponse);
        this.socket = new ServerSocket();
        this.socket.bind(address);
        this.acceptThread = ThreadUtils.DAEMON_THREAD_FACTORY.newThread(this::runAcceptThread);
        this.acceptThread.start();
    }

    private void runAcceptThread() {
        while (Thread.interrupted()) {
            try {
                Socket clientSocket = this.socket.accept();
                if (!this.isAllowConnection(clientSocket)) {
                    clientSocket.close();
                }
                ServerSocketClient client = new ServerSocketClient(this.registryRequest, this.registryResponse, clientSocket);
                this.clients.add(client);
            }
            catch (IOException e) {
                return;
            }
        }
    }

    protected boolean isAllowConnection(Socket socket) {
        return true;
    }

    @Override
    public void registerHandler(String name, AbstractServer.ServerHandler handler) {
        this.handlers.put(name, handler);
    }

    @Override
    public void unregisterHandler(String name) {
        this.handlers.remove(name);
    }

    @Override
    public void process(MessageHeader requestHeader, Object obj, AbstractServer.ServerClient client) {
    }

    @Override
    public void close() {
        for (SocketClient client : this.clients) {
            if (!client.isAlive()) continue;
            client.close();
        }
        if (!this.socket.isClosed()) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class ServerSocketClient
    extends SocketClient
    implements AbstractServer.ServerClient {
        public ServerSocketClient(Registry registryRequest, Registry registryResponse, Socket socket) {
            super(registryRequest, registryResponse, socket);
        }

        @Override
        protected void onEvent(MessageHeader header, Object obj) {
            SocketServer.this.process(header, obj, this);
        }

        @Override
        public CompletableFuture<MessageHeader> sendResponse(MessageHeader requestHeader, Object responseObj) {
            return this.send(responseObj, true, requestHeader.requestId());
        }
    }
}

